/*
 * Decompiled with CFR 0.152.
 */
package common.ui;

import common.ui.CalculatorCanvas;
import common.ui.DisplaySizes;
import common.ui.UiComponent;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public abstract class EditPanel
extends UiComponent {
    protected static final int DOUGLAS_8_STATUS_SYMBOL_Y_POS = -1;
    protected static final int DOUGLAS_8_STATUS_BAR_SEPARATOR_Y_POS = 21;
    protected static final int S60_3_1_STATUS_SYMBOL_Y_POS = -1;
    protected static final int S60_3_1_STATUS_BAR_SEPARATOR_Y_POS = 21;
    protected CalculatorCanvas calculatorCanvas = null;
    protected boolean memoryDirty = false;
    protected String memory = null;
    protected Sprite statusSymbols = null;
    protected Font statusSymbolFont = null;
    protected int memoryStatusSymbolXPos = 0;
    protected int statusSymbolYPos = 0;
    protected int statusBarSeparatorYPos = 0;
    protected int currentState = -1;

    public EditPanel(DisplaySizes displaySize) {
        super(displaySize);
        if (displaySize == DisplaySizes.DOUGLAS_8) {
            this.statusSymbolYPos = -1;
            this.statusBarSeparatorYPos = 21;
        } else if (displaySize == DisplaySizes.S60_3_1 || displaySize == DisplaySizes.S60_3_1_OLD) {
            this.statusSymbolYPos = -1;
            this.statusBarSeparatorYPos = 21;
        } else if (displaySize == DisplaySizes.S60_3_2_SDK) {
            this.statusSymbolYPos = -1;
            this.statusBarSeparatorYPos = 21;
        } else if (displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK || displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK) {
            this.statusSymbolYPos = -1;
            this.statusBarSeparatorYPos = 21;
        } else if (displaySize == DisplaySizes.TUBE_LANDSCAPE_NAV || displaySize == DisplaySizes.TUBE_LANDSCAPE_NO_KEYBOARD || displaySize == DisplaySizes.TUBE_LANDSCAPE_GAME) {
            this.statusSymbolYPos = -1;
            this.statusBarSeparatorYPos = 21;
        } else if (displaySize == DisplaySizes.TUBE_PORTRAIT_NAV || displaySize == DisplaySizes.TUBE_PORTRAIT_NO_KEYBOARD || displaySize == DisplaySizes.TUBE_PORTRAIT_GAME) {
            this.statusSymbolYPos = -1;
            this.statusBarSeparatorYPos = 21;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.statusSymbolFont = Font.getFont((int)0, (int)0, (int)0);
        g.setColor(0xFFFFFF);
        g.fillRect(this.xPos, this.yPos, this.width, this.height);
        g.setColor(0);
        g.drawRect(this.xPos, this.yPos, this.width - 1, this.height - 1);
        g.setStrokeStyle(1);
        g.drawLine(this.xPos, this.statusBarSeparatorYPos, this.width, this.statusBarSeparatorYPos);
        g.setStrokeStyle(0);
        if (this.memoryDirty && (this.displaySize == DisplaySizes.DOUGLAS_8 || this.displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK || this.displaySize == DisplaySizes.S60_3_1 || this.displaySize == DisplaySizes.S60_3_1_OLD || this.displaySize == DisplaySizes.S60_3_2_SDK || this.displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK)) {
            g.setFont(this.statusSymbolFont);
            g.drawString("M", this.memoryStatusSymbolXPos, this.statusSymbolYPos + 1, 20);
            g.setFont(this.font);
        }
    }

    public void repaint() {
        if (this.calculatorCanvas != null) {
            this.calculatorCanvas.repaint();
        }
    }

    public void setCalculatorCanvas(CalculatorCanvas calculatorCanvas) {
        this.calculatorCanvas = calculatorCanvas;
    }

    public CalculatorCanvas getCalculatorCanvas() {
        return this.calculatorCanvas;
    }

    public abstract void handlePressedButton(int var1);

    public abstract void removeLastSymbol();

    protected abstract void initEditPanel();

    protected abstract void saveToMemory();

    protected abstract boolean recallFromMemory();

    protected abstract void changeState(int var1);
}

